class DSM_TDMSB extends DSM_DMSB;

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor, BlackColor, BColor;
var PlayerReplicationInfo Ordered[32];
var float ScoreStart;	// top allowed score start
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;
var int NumTeams;

var float	RedY, BlueY, GreenY, GoldY, RedX, BlueX, GreenX, GoldX;
var bool 	bGreen, bGold;

function DrawTeamHeadlines(Canvas Canvas)
{
local float XL, YL;
local TournamentGameReplicationInfo TGRI;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	RedY += 16;
	BlueY += 16;
	GreenY += 16;
	GoldY += 16;

	if ( NumTeams == 2 )
		{
		Canvas.DrawColor = RedColor;
		Canvas.StrLen("Team Score:"@int(TGRI.Teams[0].Score), XL, YL );
		Canvas.SetPos(RedX + 190 - (0.5 * XL), RedY );
		Canvas.DrawText("Team Score:"@int(TGRI.Teams[0].Score), false );
		Canvas.DrawColor = BlueColor;
		Canvas.StrLen("Team Score:"@int(TGRI.Teams[1].Score), XL, YL );
		Canvas.SetPos(BlueX + 190 - (0.5 * XL), BlueY );
		Canvas.DrawText("Team Score:"@int(TGRI.Teams[1].Score), false );
		RedY += YL;
		BlueY += YL;
		}
	else if ( NumTeams == 3 )
		{
		Canvas.DrawColor = RedColor;
		Canvas.StrLen("Team Score:"@int(TGRI.Teams[0].Score), XL, YL );
		Canvas.SetPos(RedX + 96 - (0.5 * XL), RedY );
		Canvas.DrawText("Team Score:"@int(TGRI.Teams[0].Score), false );
		Canvas.DrawColor = BlueColor;
		Canvas.StrLen("Team Score:"@int(TGRI.Teams[1].Score), XL, YL );
		Canvas.SetPos(BlueX + 96 - (0.5 * XL), BlueY );
		Canvas.DrawText("Team Score:"@int(TGRI.Teams[1].Score), false );
		Canvas.DrawColor = GreenColor;
		Canvas.StrLen("Team Score:"@int(TGRI.Teams[2].Score), XL, YL );
		Canvas.SetPos(GreenX + 96 - (0.5 * XL), GreenY );
		Canvas.DrawText("Team Score:"@int(TGRI.Teams[2].Score), false );
		RedY += YL;
		BlueY += YL;
		GreenY += YL;
		}
	else
		{
		Canvas.DrawColor = RedColor;
		Canvas.StrLen("Team Score:"@int(TGRI.Teams[0].Score), XL, YL );
		Canvas.SetPos(RedX + 96 - (0.5 * XL), RedY );
		Canvas.DrawText("Team Score:"@int(TGRI.Teams[0].Score), false );
		Canvas.DrawColor = BlueColor;
		Canvas.StrLen("Team Score:"@int(TGRI.Teams[1].Score), XL, YL );
		Canvas.SetPos(BlueX + 96 - (0.5 * XL), BlueY );
		Canvas.DrawText("Team Score:"@int(TGRI.Teams[1].Score), false );
		Canvas.DrawColor = GreenColor;
		Canvas.StrLen("Team Score:"@int(TGRI.Teams[2].Score), XL, YL );
		Canvas.SetPos(GreenX + 96 - (0.5 * XL), GreenY );
		Canvas.DrawText("Team Score:"@int(TGRI.Teams[2].Score), false );
		Canvas.DrawColor = GoldColor;
		Canvas.StrLen("Team Score:"@int(TGRI.Teams[3].Score), XL, YL );
		Canvas.SetPos(GoldX + 96 - (0.5 * XL), GoldY );
		Canvas.DrawText("Team Score:"@int(TGRI.Teams[3].Score), false );
		RedY += YL;
		BlueY += YL;
		GreenY += YL;
		GoldY += YL;
		}
}

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL, XL2, YL2, XL3, YL3, Eff, TeamX;
local Font CanvasFont;
local bool bLocalPlayer;
local PlayerPawn PlayerOwner;
local int Time;
local Info_PRI IPRI;	

	PlayerOwner = PlayerPawn(Owner);

	bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);

	//Detect number of teams and set X position according to NumTeams:
	if (PRI.Team == 2 && !bGreen)
		bGreen=True;
	else if (PRI.Team == 3 && !bGold)
		bGold=True;

	if ( !bGreen && !bGold )
		{
		RedX = Canvas.ClipX * 0.5 - 390;
		BlueX = Canvas.ClipX * 0.5 + 10;
		NumTeams = 2;
		}
	else if ( bGreen && !bGold )
		{
		RedX = Canvas.ClipX * 0.5 - 295;
		BlueX = Canvas.ClipX * 0.5 - 95;
		GreenX = Canvas.ClipX * 0.5 + 105;
		NumTeams = 3;
		}
	else
		{
		RedX = Canvas.ClipX * 0.5 - 393;
		BlueX = Canvas.ClipX * 0.5 - 195;
		GreenX = Canvas.ClipX * 0.5 + 5;
		GoldX = Canvas.ClipX * 0.5 + 205;
		NumTeams = 4;
		}
if ( NumTeams == 2 )
	{
	//Draw Red Team Player
if (PRI.Team == 0)
	{
	TeamX = RedX;
	//Setup Background
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos(TeamX , RedY);
	Canvas.DrawTile(Texture'Blackness', 380, 1, 0, 0, 1, 1);
	Canvas.SetPos(TeamX , RedY + 31);
	Canvas.DrawTile(Texture'Blackness', 380, 1, 0, 0, 1, 1);
	Canvas.SetPos(TeamX , RedY + 1);
	Canvas.DrawTile(Texture'Blackness', 1, 30, 0, 0, 1, 1);
	Canvas.SetPos(TeamX + 379, RedY + 1);
	Canvas.DrawTile(Texture'Blackness', 1, 30, 0, 0, 1, 1);
	Canvas.DrawColor.R = 20;
	Canvas.DrawColor.G = 20;
	Canvas.DrawColor.B = 20;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(TeamX + 1, RedY + 1);
	Canvas.DrawTile(Texture'Whiteness', 378, 30, 0, 0, 1, 1);

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(TeamX + 1, RedY + 1);
	Canvas.DrawTile(PRI.TalkTexture, 30, 30, 0, 0, 64, 64);
	Canvas.SetPos(TeamX + 349, RedY + 1);
	Canvas.Style = ERenderStyle.STY_Translucent;
	if ( !PRI.bIsABot )
		{
		if ( PRI.Ping > 250 )
			{
			Canvas.DrawTile(Texture'Icon_Con1', 30, 30, 0, 0, 128, 128);
			}
		else if ( PRI.Ping > 150 )
			{
			Canvas.DrawTile(Texture'Icon_Con2', 30, 30, 0, 0, 128, 128);
			}
		else if ( PRI.Ping > 80 )
			{
			Canvas.DrawTile(Texture'Icon_Con3', 30, 30, 0, 0, 128, 128);
			}
		else
			{
			Canvas.DrawTile(Texture'Icon_Con4', 30, 30, 0, 0, 128, 128);
			}
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.Font = MyFonts.GetAReallySmallFont(Canvas.ClipX);
		Canvas.DrawColor = BColor;
		Canvas.StrLen(PRI.Ping, XL, YL );
		Canvas.SetPos(TeamX + 366 - 0.5 * XL, RedY + 19 );
		Canvas.DrawText(PRI.Ping, false );
		Canvas.DrawColor = WhiteColor;
		Canvas.StrLen(PRI.Ping, XL, YL );
		Canvas.SetPos(TeamX + 365 - 0.5 * XL, RedY + 18 );
		Canvas.DrawText(PRI.Ping, false );
		}
	else
		{
		Canvas.DrawTile(Texture'Icon_cpu', 30, 30, 0, 0, 64, 64);
		}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( PRI.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = RedColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.SetPos(TeamX + 32 , RedY );
	Canvas.DrawText(PRI.PlayerName, False);
	
	Canvas.DrawColor = SilverColor;
	Canvas.Font = MyFonts.GetAReallySmallFont(Canvas.ClipX);
	Canvas.SetPos(TeamX + 32, RedY + 18 );

	if ( !PRI.bIsABot )
		Canvas.DrawText("Frags:"@int(PRI.Score)$"/"$Info_PRI(PRI).TotalFrags$", Deaths:"@int(PRI.Deaths)$"/"$Info_PRI(PRI).TotalDeaths$", Headshots:"@Info_PRI(PRI).Headshots$"/"$Info_PRI(PRI).TotalHeadShots$", Games:"@Info_PRI(PRI).Games, false );
	else
		Canvas.DrawText("Frags:"@int(PRI.Score)$", Deaths:"@int(PRI.Deaths), false );

	if ( PRI.Score > 0 )
		{
		Eff = PRI.Score / (PRI.Score + PRI.Deaths);
		}
	else
		{
		Eff = 0;
		}
	Eff *= 100;
	Canvas.StrLen("Eff:"@int(Eff)$"%", XL, YL );
	Canvas.SetPos(TeamX + 349 - XL, RedY );
	if (Eff < 20 )
		Canvas.DrawColor = RedColor;
	else if (Eff < 66 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.DrawText("Eff:"@int(Eff)$"%", false );
	RedY += 33;
	}

//Draw Blue Team Player
else if (PRI.Team == 1)
	{
	TeamX = BlueX;
	//Setup Background
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos(TeamX , BlueY);
	Canvas.DrawTile(Texture'Blackness', 380, 1, 0, 0, 1, 1);
	Canvas.SetPos(TeamX , BlueY + 31);
	Canvas.DrawTile(Texture'Blackness', 380, 1, 0, 0, 1, 1);
	Canvas.SetPos(TeamX , BlueY + 1);
	Canvas.DrawTile(Texture'Blackness', 1, 30, 0, 0, 1, 1);
	Canvas.SetPos(TeamX + 379, BlueY + 1);
	Canvas.DrawTile(Texture'Blackness', 1, 30, 0, 0, 1, 1);
	Canvas.DrawColor.R = 20;
	Canvas.DrawColor.G = 20;
	Canvas.DrawColor.B = 20;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(TeamX + 1, BlueY + 1);
	Canvas.DrawTile(Texture'Whiteness', 378, 30, 0, 0, 1, 1);

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(TeamX + 1, BlueY + 1);
	Canvas.DrawTile(PRI.TalkTexture, 30, 30, 0, 0, 64, 64);
	Canvas.SetPos(TeamX + 349, BlueY + 1);
	Canvas.Style = ERenderStyle.STY_Translucent;
	if ( !PRI.bIsABot )
		{
		if ( PRI.Ping > 250 )
			{
			Canvas.DrawTile(Texture'Icon_Con1', 30, 30, 0, 0, 128, 128);
			}
		else if ( PRI.Ping > 150 )
			{
			Canvas.DrawTile(Texture'Icon_Con2', 30, 30, 0, 0, 128, 128);
			}
		else if ( PRI.Ping > 80 )
			{
			Canvas.DrawTile(Texture'Icon_Con3', 30, 30, 0, 0, 128, 128);
			}
		else
			{
			Canvas.DrawTile(Texture'Icon_Con4', 30, 30, 0, 0, 128, 128);
			}
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.Font = MyFonts.GetAReallySmallFont(Canvas.ClipX);
		Canvas.DrawColor = BColor;
		Canvas.StrLen(PRI.Ping, XL, YL );
		Canvas.SetPos(TeamX + 366 - 0.5 * XL, BlueY + 19 );
		Canvas.DrawText(PRI.Ping, false );
		Canvas.DrawColor = WhiteColor;
		Canvas.StrLen(PRI.Ping, XL, YL );
		Canvas.SetPos(TeamX + 365 - 0.5 * XL, BlueY + 18 );
		Canvas.DrawText(PRI.Ping, false );
		}
	else
		{
		Canvas.DrawTile(Texture'Icon_cpu', 30, 30, 0, 0, 64, 64);
		}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( PRI.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = BlueColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.SetPos(TeamX + 32 , BlueY );
	Canvas.DrawText(PRI.PlayerName, False);
	
	Canvas.DrawColor = SilverColor;
	Canvas.Font = MyFonts.GetAReallySmallFont(Canvas.ClipX);
	Canvas.SetPos(TeamX + 32, BlueY + 18 );

	if ( !PRI.bIsABot )
		Canvas.DrawText("Frags:"@int(PRI.Score)$"/"$Info_PRI(PRI).TotalFrags$", Deaths:"@int(PRI.Deaths)$"/"$Info_PRI(PRI).TotalDeaths$", Headshots:"@Info_PRI(PRI).Headshots$"/"$Info_PRI(PRI).TotalHeadShots$", Games:"@Info_PRI(PRI).Games, false );
	else
		Canvas.DrawText("Frags:"@int(PRI.Score)$", Deaths:"@int(PRI.Deaths), false );

	if ( PRI.Score > 0 )
		{
		Eff = PRI.Score / (PRI.Score + PRI.Deaths);
		}
	else
		{
		Eff = 0;
		}
	Eff *= 100;
	Canvas.StrLen("Eff:"@int(Eff)$"%", XL, YL );
	Canvas.SetPos(TeamX + 349 - XL, BlueY);
	if (Eff < 20 )
		Canvas.DrawColor = RedColor;
	else if (Eff < 66 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.DrawText("Eff:"@int(Eff)$"%", false );
	BlueY += 33;
	}
	}
else
	{
//Draw Red Team Player
if (PRI.Team == 0)
	{
	TeamX = RedX;
	//Setup Background
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos(TeamX , RedY);
	Canvas.DrawTile(Texture'Blackness', 190, 1, 0, 0, 1, 1);
	Canvas.SetPos(TeamX , RedY + 31);
	Canvas.DrawTile(Texture'Blackness', 190, 1, 0, 0, 1, 1);
	Canvas.SetPos(TeamX , RedY + 1);
	Canvas.DrawTile(Texture'Blackness', 1, 30, 0, 0, 1, 1);
	Canvas.SetPos(TeamX + 189, RedY + 1);
	Canvas.DrawTile(Texture'Blackness', 1, 30, 0, 0, 1, 1);
	Canvas.DrawColor.R = 20;
	Canvas.DrawColor.G = 20;
	Canvas.DrawColor.B = 20;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(TeamX + 1, RedY + 1);
	Canvas.DrawTile(Texture'Whiteness', 188, 30, 0, 0, 1, 1);

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(TeamX + 1, RedY + 1);
	Canvas.DrawTile(PRI.TalkTexture, 30, 30, 0, 0, 64, 64);
	Canvas.SetPos(TeamX + 32, RedY + 17);
	Canvas.DrawTile(Texture'Icon_Frags', 14, 14, 0, 0, 32, 32);
	Canvas.SetPos(TeamX + 74, RedY + 17);
	Canvas.DrawTile(Texture'Icon_Deaths', 14, 14, 0, 0, 32, 32);
	Canvas.SetPos(TeamX + 116, RedY + 17);
	Canvas.DrawTile(Texture'Icon_Eff', 14, 14, 0, 0, 32, 32);
	Canvas.SetPos(TeamX + 159, RedY + 1);
	Canvas.Style = ERenderStyle.STY_Translucent;
	if ( !PRI.bIsABot )
		{
		if ( PRI.Ping > 250 )
			{
			Canvas.DrawTile(Texture'Icon_Con1', 26, 26, 0, 0, 128, 128);
			}
		else if ( PRI.Ping > 150 )
			{
			Canvas.DrawTile(Texture'Icon_Con2', 26, 26, 0, 0, 128, 128);
			}
		else if ( PRI.Ping > 80 )
			{
			Canvas.DrawTile(Texture'Icon_Con3', 26, 26, 0, 0, 128, 128);
			}
		else
			{
			Canvas.DrawTile(Texture'Icon_Con4', 26, 26, 0, 0, 128, 128);
			}
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = BColor;
		Canvas.StrLen(PRI.Ping, XL, YL );
		Canvas.SetPos(TeamX + 364 - 0.5 * XL, RedY + 19 );
		Canvas.DrawText(PRI.Ping, false );
		Canvas.DrawColor = WhiteColor;
		Canvas.StrLen(PRI.Ping, XL, YL );
		Canvas.SetPos(TeamX + 363 - 0.5 * XL, RedY + 18 );
		Canvas.DrawText(PRI.Ping, false );
		}
	else
		{
		Canvas.DrawTile(Texture'Icon_cpu', 26, 26, 0, 0, 64, 64);
		}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( PRI.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = RedColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.SetPos(TeamX + 32 , RedY + 1);
	Canvas.DrawText(PRI.PlayerName, False);
	
	Canvas.StrLen( PRI.Ping, XL, YL );

	Canvas.DrawColor = SilverColor;
	Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);
	Canvas.SetPos(TeamX + 47, RedY + 17 );
	Canvas.DrawText(int(PRI.Score), false );
	Canvas.SetPos(TeamX + 89, RedY + 17 );
	Canvas.DrawText(int(PRI.Deaths), false );
	Canvas.SetPos(TeamX + 174 - 0.5 * XL, RedY + 17 );

	if ( PRI.Score > 0 )
		{
		Eff = PRI.Score / (PRI.Score + PRI.Deaths);
		}
	else
		{
		Eff = 0;
		}
	Eff *= 100;
	Canvas.SetPos(TeamX + 131, RedY + 17);
	if (Eff < 20 )
		Canvas.DrawColor = RedColor;
	else if (Eff < 66 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.DrawText(int(Eff), false );
	RedY += 33;
	}

//Draw Blue Team Player
else if (PRI.Team == 1)
	{
	TeamX = BlueX;
	//Setup Background
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos(TeamX , BlueY);
	Canvas.DrawTile(Texture'Blackness', 190, 1, 0, 0, 1, 1);
	Canvas.SetPos(TeamX , BlueY + 31);
	Canvas.DrawTile(Texture'Blackness', 190, 1, 0, 0, 1, 1);
	Canvas.SetPos(TeamX , BlueY + 1);
	Canvas.DrawTile(Texture'Blackness', 1, 30, 0, 0, 1, 1);
	Canvas.SetPos(TeamX + 189, BlueY + 1);
	Canvas.DrawTile(Texture'Blackness', 1, 30, 0, 0, 1, 1);
	Canvas.DrawColor.R = 20;
	Canvas.DrawColor.G = 20;
	Canvas.DrawColor.B = 20;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(TeamX + 1, BlueY + 1);
	Canvas.DrawTile(Texture'Whiteness', 188, 30, 0, 0, 1, 1);

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(TeamX + 1, BlueY + 1);
	Canvas.DrawTile(PRI.TalkTexture, 30, 30, 0, 0, 64, 64);
	Canvas.SetPos(TeamX + 32, BlueY + 17);
	Canvas.DrawTile(Texture'Icon_Frags', 14, 14, 0, 0, 32, 32);
	Canvas.SetPos(TeamX + 74, BlueY + 17);
	Canvas.DrawTile(Texture'Icon_Deaths', 14, 14, 0, 0, 32, 32);
	Canvas.SetPos(TeamX + 116, BlueY + 17);
	Canvas.DrawTile(Texture'Icon_Eff', 14, 14, 0, 0, 32, 32);
	Canvas.SetPos(TeamX + 159, BlueY + 1);
	Canvas.Style = ERenderStyle.STY_Translucent;
	if ( !PRI.bIsABot )
		{
		if ( PRI.Ping > 250 )
			{
			Canvas.DrawTile(Texture'Icon_Con1', 26, 26, 0, 0, 128, 128);
			}
		else if ( PRI.Ping > 150 )
			{
			Canvas.DrawTile(Texture'Icon_Con2', 26, 26, 0, 0, 128, 128);
			}
		else if ( PRI.Ping > 80 )
			{
			Canvas.DrawTile(Texture'Icon_Con3', 26, 26, 0, 0, 128, 128);
			}
		else
			{
			Canvas.DrawTile(Texture'Icon_Con4', 26, 26, 0, 0, 128, 128);
			}
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = BColor;
		Canvas.StrLen(PRI.Ping, XL, YL );
		Canvas.SetPos(TeamX + 364 - 0.5 * XL, RedY + 19 );
		Canvas.DrawText(PRI.Ping, false );
		Canvas.DrawColor = WhiteColor;
		Canvas.StrLen(PRI.Ping, XL, YL );
		Canvas.SetPos(TeamX + 363 - 0.5 * XL, RedY + 18 );
		Canvas.DrawText(PRI.Ping, false );
		}
	else
		{
		Canvas.DrawTile(Texture'Icon_cpu', 26, 26, 0, 0, 64, 64);
		}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( PRI.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = BlueColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.SetPos(TeamX + 32 , BlueY + 1);
	Canvas.DrawText(PRI.PlayerName, False);
	
	Canvas.StrLen( PRI.Ping, XL, YL );

	Canvas.DrawColor = SilverColor;
	Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);
	Canvas.SetPos(TeamX + 47, BlueY + 17 );
	Canvas.DrawText(int(PRI.Score), false );
	Canvas.SetPos(TeamX + 89, BlueY + 17 );
	Canvas.DrawText(int(PRI.Deaths), false );
	Canvas.SetPos(TeamX + 174 - 0.5 * XL, BlueY + 17 );

	if ( PRI.Score > 0 )
		{
		Eff = PRI.Score / (PRI.Score + PRI.Deaths);
		}
	else
		{
		Eff = 0;
		}
	Eff *= 100;
	Canvas.SetPos(TeamX + 131, BlueY + 17);
	if (Eff < 20 )
		Canvas.DrawColor = RedColor;
	else if (Eff < 66 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.DrawText(int(Eff), false );
	BlueY += 33;
	}

//Draw Green Team Player
else if (PRI.Team == 2)
	{
	TeamX = GreenX;
	//Setup Background
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos(TeamX , GreenY);
	Canvas.DrawTile(Texture'Blackness', 190, 1, 0, 0, 1, 1);
	Canvas.SetPos(TeamX , GreenY + 31);
	Canvas.DrawTile(Texture'Blackness', 190, 1, 0, 0, 1, 1);
	Canvas.SetPos(TeamX , GreenY + 1);
	Canvas.DrawTile(Texture'Blackness', 1, 30, 0, 0, 1, 1);
	Canvas.SetPos(TeamX + 189, GreenY + 1);
	Canvas.DrawTile(Texture'Blackness', 1, 30, 0, 0, 1, 1);
	Canvas.DrawColor.R = 20;
	Canvas.DrawColor.G = 20;
	Canvas.DrawColor.B = 20;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(TeamX + 1, GreenY + 1);
	Canvas.DrawTile(Texture'Whiteness', 188, 30, 0, 0, 1, 1);

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(TeamX + 1, GreenY + 1);
	Canvas.DrawTile(PRI.TalkTexture, 30, 30, 0, 0, 64, 64);
	Canvas.SetPos(TeamX + 32, GreenY + 17);
	Canvas.DrawTile(Texture'Icon_Frags', 14, 14, 0, 0, 32, 32);
	Canvas.SetPos(TeamX + 74, GreenY + 17);
	Canvas.DrawTile(Texture'Icon_Deaths', 14, 14, 0, 0, 32, 32);
	Canvas.SetPos(TeamX + 116, GreenY + 17);
	Canvas.DrawTile(Texture'Icon_Eff', 14, 14, 0, 0, 32, 32);
	Canvas.SetPos(TeamX + 159, GreenY + 1);
	Canvas.Style = ERenderStyle.STY_Translucent;
	if ( !PRI.bIsABot )
		{
		if ( PRI.Ping > 250 )
			{
			Canvas.DrawTile(Texture'Icon_Con1', 26, 26, 0, 0, 128, 128);
			}
		else if ( PRI.Ping > 150 )
			{
			Canvas.DrawTile(Texture'Icon_Con2', 26, 26, 0, 0, 128, 128);
			}
		else if ( PRI.Ping > 80 )
			{
			Canvas.DrawTile(Texture'Icon_Con3', 26, 26, 0, 0, 128, 128);
			}
		else
			{
			Canvas.DrawTile(Texture'Icon_Con4', 26, 26, 0, 0, 128, 128);
			}
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = BColor;
		Canvas.StrLen(PRI.Ping, XL, YL );
		Canvas.SetPos(TeamX + 364 - 0.5 * XL, RedY + 19 );
		Canvas.DrawText(PRI.Ping, false );
		Canvas.DrawColor = WhiteColor;
		Canvas.StrLen(PRI.Ping, XL, YL );
		Canvas.SetPos(TeamX + 363 - 0.5 * XL, RedY + 18 );
		Canvas.DrawText(PRI.Ping, false );
		}
	else
		{
		Canvas.DrawTile(Texture'Icon_cpu', 26, 26, 0, 0, 64, 64);
		}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( PRI.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.SetPos(TeamX + 32 , GreenY + 1);
	Canvas.DrawText(PRI.PlayerName, False);
	
	Canvas.StrLen( PRI.Ping, XL, YL );

	Canvas.DrawColor = SilverColor;
	Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);
	Canvas.SetPos(TeamX + 47, GreenY + 17 );
	Canvas.DrawText(int(PRI.Score), false );
	Canvas.SetPos(TeamX + 89, GreenY + 17 );
	Canvas.DrawText(int(PRI.Deaths), false );
	Canvas.SetPos(TeamX + 174 - 0.5 * XL, GreenY + 17 );

	if ( PRI.Score > 0 )
		{
		Eff = PRI.Score / (PRI.Score + PRI.Deaths);
		}
	else
		{
		Eff = 0;
		}
	Eff *= 100;
	Canvas.SetPos(TeamX + 131, GreenY + 17);
	if (Eff < 20 )
		Canvas.DrawColor = RedColor;
	else if (Eff < 66 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.DrawText(int(Eff), false );
	GreenY += 33;
	}

//Draw Gold Team Player
else if (PRI.Team == 3)
	{
	TeamX = GoldX;
	//Setup Background
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos(TeamX , GoldY);
	Canvas.DrawTile(Texture'Blackness', 190, 1, 0, 0, 1, 1);
	Canvas.SetPos(TeamX , GoldY + 31);
	Canvas.DrawTile(Texture'Blackness', 190, 1, 0, 0, 1, 1);
	Canvas.SetPos(TeamX , GoldY + 1);
	Canvas.DrawTile(Texture'Blackness', 1, 30, 0, 0, 1, 1);
	Canvas.SetPos(TeamX + 189, GoldY + 1);
	Canvas.DrawTile(Texture'Blackness', 1, 30, 0, 0, 1, 1);
	Canvas.DrawColor.R = 20;
	Canvas.DrawColor.G = 20;
	Canvas.DrawColor.B = 20;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(TeamX + 1, GoldY + 1);
	Canvas.DrawTile(Texture'Whiteness', 188, 30, 0, 0, 1, 1);

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(TeamX + 1, GoldY + 1);
	Canvas.DrawTile(PRI.TalkTexture, 30, 30, 0, 0, 64, 64);
	Canvas.SetPos(TeamX + 32, GoldY + 17);
	Canvas.DrawTile(Texture'Icon_Frags', 14, 14, 0, 0, 32, 32);
	Canvas.SetPos(TeamX + 74, GoldY + 17);
	Canvas.DrawTile(Texture'Icon_Deaths', 14, 14, 0, 0, 32, 32);
	Canvas.SetPos(TeamX + 116, GoldY + 17);
	Canvas.DrawTile(Texture'Icon_Eff', 14, 14, 0, 0, 32, 32);
	Canvas.SetPos(TeamX + 159, GoldY + 1);
	Canvas.Style = ERenderStyle.STY_Translucent;
	if ( !PRI.bIsABot )
		{
		if ( PRI.Ping > 250 )
			{
			Canvas.DrawTile(Texture'Icon_Con1', 26, 26, 0, 0, 128, 128);
			}
		else if ( PRI.Ping > 150 )
			{
			Canvas.DrawTile(Texture'Icon_Con2', 26, 26, 0, 0, 128, 128);
			}
		else if ( PRI.Ping > 80 )
			{
			Canvas.DrawTile(Texture'Icon_Con3', 26, 26, 0, 0, 128, 128);
			}
		else
			{
			Canvas.DrawTile(Texture'Icon_Con4', 26, 26, 0, 0, 128, 128);
			}
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = BColor;
		Canvas.StrLen(PRI.Ping, XL, YL );
		Canvas.SetPos(TeamX + 364 - 0.5 * XL, RedY + 19 );
		Canvas.DrawText(PRI.Ping, false );
		Canvas.DrawColor = WhiteColor;
		Canvas.StrLen(PRI.Ping, XL, YL );
		Canvas.SetPos(TeamX + 363 - 0.5 * XL, RedY + 18 );
		Canvas.DrawText(PRI.Ping, false );
		}
	else
		{
		Canvas.DrawTile(Texture'Icon_cpu', 26, 26, 0, 0, 64, 64);
		}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( PRI.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else if ( bLocalPlayer ) 
		Canvas.DrawColor = SilverColor;
	else 
		Canvas.DrawColor = GoldColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.SetPos(TeamX + 32 , GoldY + 1);
	Canvas.DrawText(PRI.PlayerName, False);
	
	Canvas.StrLen( PRI.Ping, XL, YL );

	Canvas.DrawColor = SilverColor;
	Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);
	Canvas.SetPos(TeamX + 47, GoldY + 17 );
	Canvas.DrawText(int(PRI.Score), false );
	Canvas.SetPos(TeamX + 89, GoldY + 17 );
	Canvas.DrawText(int(PRI.Deaths), false );
	Canvas.SetPos(TeamX + 174 - 0.5 * XL, GoldY + 17 );

	if ( PRI.Score > 0 )
		{
		Eff = PRI.Score / (PRI.Score + PRI.Deaths);
		}
	else
		{
		Eff = 0;
		}
	Eff *= 100;
	Canvas.SetPos(TeamX + 131, GoldY + 17);
	if (Eff < 20 )
		Canvas.DrawColor = RedColor;
	else if (Eff < 66 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.DrawText(int(Eff), false );
	GoldY += 33;
	}
	}
}

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function DrawHeader( canvas Canvas )
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local font CanvasFont;

	Canvas.DrawColor = WhiteColor;
	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	Canvas.bCenter = True;
	Canvas.StrLen("Test", XL, YL);
	ScoreStart = 16;
	CanvasFont = Canvas.Font;
	if ( GRI.GameEndedComments != "" )
	{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, ScoreStart);
		Canvas.DrawText(GRI.GameEndedComments, True);
	}
	else
	{
		Canvas.SetPos(0, ScoreStart);
		DrawVictoryConditions(Canvas);
	}
	Canvas.bCenter = False;
	Canvas.Font = CanvasFont;
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	Canvas.DrawText(TGRI.GameName);
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, Canvas.CurY - YL);


	Canvas.DrawText("Fraglimit:"@TGRI.GoalTeamScore$", Timelimit:"@TGRI.TimeLimit$":00");

}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);
	if ( (Level.NetMode == NM_Standalone) && Level.Game.IsA('DeathMatchPlus') )
	{
		if ( DeathMatchPlus(Level.Game).bRatedGame )
			Canvas.DrawText(DeathMatchPlus(Level.Game).RatedGameLadderObj.SkillText@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else if ( DeathMatchPlus(Level.Game).bNoviceMode ) 
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else  
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty + 4]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
	}
	else
		Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

function SortScores(int N)
{
	local int I, J, Max;
	local PlayerReplicationInfo TempPRI;
	
	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

function ShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
	local float XL, YL, Scale;
	local float YOffset, YStart;
	local font CanvasFont;

	DrawUT(canvas);

	Canvas.Style = ERenderStyle.STY_Normal;

	// Header
	Canvas.SetPos(0, 0);
	DrawHeader(Canvas);

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}
	SortScores(PlayerCount);
	
	CanvasFont = Canvas.Font;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	Canvas.StrLen( "TEST", XL, YL );

	YStart = YL * 2;

	RedY = YStart;
	BlueY = YStart;
	GreenY = YStart;
	GoldY = YStart;

	DrawTeamHeadlines(Canvas);

	for ( I=0; I<PlayerCount; I++ )
	{
		DrawNameAndPing( Canvas, Ordered[I], 0, YOffset, false );
	}

}

defaultproperties
{
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The match has ended."
     ElapsedTime="Elapsed Time: "
     RemainingTime="Remaining Time: "
     FragGoal="Frag Limit:"
     TimeLimit="Time Limit:"
     PlayerString="Player"
     FragsString="Frags"
     DeathsString="Deaths"
     PingString="Ping"
     TimeString="Time"
     LossString="Loss"
     FPHString="FPH"
     GreenColor=(G=255)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
     BColor=(R=0,G=0,B=0)
}
